#include <stdio.h>
#include "pico/stdlib.h"


// dont forget in cmakelists.txt target_link_libraries(R2RdacSigGenSweepedWithFIFO_1V01 pico_stdlib pico_multicore)

#include "pico/multicore.h"

#include <math.h>
#include "hardware/irq.h"
#include "hardware/uart.h"
#include <C:\abOssmann\PiPico\installation\Pico\pico-sdk\src\rp2_common\hardware_pwm\include\hardware\pwm.h>


#define dacMask 0x000003FC

#define PWM_PIN1 10
#define PWM_PIN2 12   // pin 16
#define PWM_PIN3 13   // pin 17

float twopi = 2*M_PI ;
volatile int DDStable[4096] ;

#define cpuClkKhz 160000
#define pwmPeriod1 80
#define pwmPeriod2 1000

float  sampleFrequency ;
#define Tone1FRQ (500e3)
int Tone1ddsFrequency ;
int Tone1ddsPhase ;

uint8_t dacVal ;
char stxt[128] ;

//-----------------------------------------------------------------------------------

#define FIFOsize 256
#define FIFOmask (FIFOsize-1)

int FIFO[FIFOsize] ;
volatile int FIFOinPtr ;
volatile int FIFOoutPtr ;

void FIFOinit(){
  FIFOinPtr=0 ;
  FIFOoutPtr=1 ;
  }

int FIFOfull(){
  int state ;
  int flag ;
 // state=save_and_disable_interrupts () ;
  flag= FIFOinPtr==FIFOoutPtr ;
 // restore_interrupts (state) ;
  return flag ;
  }

void on_pwm_wrap() {
  pwm_clear_irq(pwm_gpio_to_slice_num(PWM_PIN1));
  gpio_put_masked(dacMask,FIFO[FIFOoutPtr]) ;
  FIFOoutPtr=(FIFOoutPtr+1) & FIFOmask ;
  }

void generate(){
  while(1){  
    uint16_t nextVal=DDStable[ (Tone1ddsPhase >> 20 ) & 0xFFF ] ;
    Tone1ddsPhase=Tone1ddsPhase+Tone1ddsFrequency ;
    while(FIFOfull() ){}
    FIFO[FIFOinPtr]=nextVal ;
    FIFOinPtr=(FIFOinPtr+1) & FIFOmask ;
    }
  }   

//-----------------------------------------------------------------------------------

void uart_puts2(char * cp){
  char cc ;
  while(cc=*cp++){
    if(cc=='\n') { uart_putc(uart0,13) ; uart_putc(uart0,10) ; }
     else { uart_putc(uart0,cc) ; }
    }
  }

void PWMsetup(){    
  gpio_set_function(PWM_PIN1, GPIO_FUNC_PWM);
  gpio_set_function(PWM_PIN2, GPIO_FUNC_PWM);
  gpio_set_function(PWM_PIN3, GPIO_FUNC_PWM);
  // Figure out which slice we just connected to the pin
  uint slice_num1 = pwm_gpio_to_slice_num(PWM_PIN1);
  uint slice_num2 = pwm_gpio_to_slice_num(PWM_PIN2);
  uint slice_num3 = pwm_gpio_to_slice_num(PWM_PIN3);
  sprintf(stxt,"slicenum1=%d\n",slice_num1) ; uart_puts2( stxt);
  sprintf(stxt,"slicenum2=%d\n",slice_num2) ; uart_puts2( stxt);
  sprintf(stxt,"slicenum3=%d\n",slice_num3) ; uart_puts2( stxt);

  // Mask our slice's IRQ output into the PWM block's single interrupt line,
  // and register our interrupt handler
  pwm_clear_irq(slice_num1);
  pwm_set_irq_enabled(slice_num1, true);
  irq_set_exclusive_handler(PWM_IRQ_WRAP, on_pwm_wrap);
  irq_set_enabled(PWM_IRQ_WRAP, true);
  // Get some sensible defaults for the slice configuration. 
  pwm_config config1 = pwm_get_default_config();
  pwm_config config2 = pwm_get_default_config();
  pwm_config config3 = pwm_get_default_config();
  // Set divider, reduces counter clock to sysclock/this value
  pwm_config_set_clkdiv(&config1, 1.f);
  pwm_config_set_clkdiv(&config2, 1.f);
  pwm_config_set_clkdiv(&config3, 1.f);
  // Load the configuration into our PWM slice, and set it running.
  pwm_init(slice_num1, &config1, true);
  pwm_init(slice_num2, &config2, true);
  //pwm_init(slice_num3, &config3, true); // slice_num3=slice_num2
 

  pwm_set_wrap(slice_num1,(pwmPeriod1-1) );
  pwm_set_wrap(slice_num2,(pwmPeriod2-1) );
  sampleFrequency=cpuClkKhz*1e3/pwmPeriod1/1.0 ;
  sprintf(stxt,"sampleFrequency=%15.5f\n",sampleFrequency) ; uart_puts2( stxt);
  sprintf(stxt,"PWM_PIN1=%d\n",PWM_PIN1) ; uart_puts2( stxt);
  sprintf(stxt,"config1=%d\n",config1) ; uart_puts2( stxt);
  sprintf(stxt,"\n") ; uart_puts2( stxt);
  sprintf(stxt,"PWM_PIN2=%d\n",PWM_PIN2) ; uart_puts2( stxt);
  sprintf(stxt,"config2=%d\n",config2) ; uart_puts2( stxt);

  pwm_set_gpio_level(PWM_PIN1, 25 );
  pwm_set_gpio_level(PWM_PIN2, 500 );
  pwm_set_gpio_level(PWM_PIN3, 500 );

  }

char getEchoedChar(){
  char cc=uart_getc(uart0) ;
  uart_putc(uart0,cc) ; 
  return cc ;
  }

float triangle(float x){
  if(x<=M_PI/2){ return x/(M_PI/2.0) ; }
  if(x<=M_PI){ return triangle(M_PI-x) ; }
  return -triangle(2*M_PI-x) ;
  }

#define offset 128
int level=127 ;
int sweepNpoints=100 ;
int sweepDelay=10000 ;
int sweepFrqA=10000 ;
int sweepFrqB=20000 ;

void oneSweep(){
  for(int k=0 ; k<sweepNpoints ; k++){
    if(uart_is_readable(uart0)){ return ; }
    float sfrq=sweepFrqA+(sweepFrqB-sweepFrqA)*k/((float)sweepNpoints) ;
    Tone1ddsFrequency=(sfrq)/sampleFrequency*(double)(0x100000000L) ;  
    int pwm=(int)(1000.0*k/((float)sweepNpoints)) ;
    pwm_set_gpio_level(PWM_PIN3, pwm );
    sleep_us(sweepDelay) ;
    }
  }

void sweep(){
  uart_puts2("\nsweeping, press any key to stop\n") ;  
  while(1){
    oneSweep() ;
    if(uart_is_readable(uart0)){ 
      uart_getc(uart0) ; 
      return ; 
      }
    }
  }

int getInt(){
  int nn=0 ;
  char cc ;
  cc=getEchoedChar() ;
  while( ('0'<=cc)&(cc<='9')  ){
    nn=10*nn+cc-'0' ;  
    cc=getEchoedChar() ; 
    }
  return nn ;  
  }

void setFrq(){
  int frq=0 ;  
  sprintf(stxt,"\nenter frq>") ; uart_puts2(stxt) ;
  frq=getInt() ;
  Tone1ddsFrequency=((float)frq)/sampleFrequency*(double)(0x100000000L) ;  
  sprintf(stxt,"\n frq=%12d Hz\n",frq) ; uart_puts2( stxt);
  }

void setFrqStart(){
  int frq=0 ;  
  sprintf(stxt,"\nenter fStart>") ; uart_puts2(stxt) ;
  frq=getInt() ;
  sweepFrqA=frq ;
  sprintf(stxt,"\n fStart=%12d Hz\n",frq) ; uart_puts2( stxt);
  }  

void setFrqStop(){
  int frq=0 ;  
  sprintf(stxt,"\nenter fStop>") ; uart_puts2(stxt) ;
  frq=getInt() ;
  sweepFrqB=frq ;
  sprintf(stxt,"\n fStop=%12d Hz\n",frq) ; uart_puts2( stxt);
  }    

void setDelay(){
  int dd=0 ;  
  sprintf(stxt,"\nenter Delay(us)>") ; uart_puts2(stxt) ;
  dd=getInt() ;
  sweepDelay=dd ;
  sprintf(stxt,"\n Delay=%12d us\n",dd) ; uart_puts2( stxt);
  }     

void setSweepN(){
  int nn=0 ;  
  sprintf(stxt,"\nenter Npoints>") ; uart_puts2(stxt) ;
  nn=getInt() ;
  sweepNpoints=nn ;
  sprintf(stxt,"\n Npoints=%12d \n",nn) ; uart_puts2( stxt);
  }    

void setLevel(){
  int ll=0 ;  
  sprintf(stxt,"\nenter Level (0..127) >") ; uart_puts2(stxt) ;
  ll=getInt() ;
  level=ll ;
  sprintf(stxt,"\n Level=%12d \n",level) ; uart_puts2( stxt);
  }    

void setSine(){
  for(int k=0 ; k<4096 ; k++){
    DDStable[k]=((int)(offset+level*sin(twopi*k/4096.0)))<<2 ;
    }
  }

void setTriangle(){
  for(int k=0 ; k<4096 ; k++){
    DDStable[k]=((int)(offset+level*triangle(twopi*k/4096.0)))<<2 ;
    }
  }

void setRectangle(){
  for(int k=0 ; k<4096 ; k++){
    if(k<2048){ DDStable[k]=(offset+level)<<2 ; }
     else { DDStable[k]=(offset-level)<<2 ; }
    }
  }

void help(){
  uart_puts2("\n\n ") ;
  uart_puts2(" h : help \n") ;
  uart_puts2(" f : setFrq, enter frequency in Hz as integer \n") ;
  uart_puts2(" s : setSine \n") ;
  uart_puts2(" t : setTriangle \n") ;
  uart_puts2(" r : setRectangle \n") ;
  uart_puts2(" w : sweep, start sweeping with the parameters set\n") ;
  uart_puts2(" a : setFrqStart \n") ;
  uart_puts2(" p : setFrqStop \n") ;
  uart_puts2(" d : setDelay, enter delay between two sweep steps as us \n") ;
  uart_puts2(" n : setSweepN, enter number of frequency points in sweep \n") ;
  uart_puts2(" l : setLevel, set the amplitude level as integer, max=127 \n") ; 
  }

void serCtrl(){
  while(1){
    uart_puts2("\nEnter command>");
    char c=getEchoedChar() ;
    switch(c){
      case 'h' : help() ; break ;
      case 'f' : setFrq() ; break ;
      case 's' : setSine() ; break ;
      case 't' : setTriangle() ; break ;
      case 'r' : setRectangle() ; break ;
      case 'w' : sweep() ; break ;
      case 'a' : setFrqStart() ; break ;
      case 'p' : setFrqStop() ; break ;
      case 'd' : setDelay() ; break ;
      case 'n' : setSweepN() ; break ;
      case 'l' : setLevel() ; break ;
      default : { }
      }
    }
  }

int main(){
  set_sys_clock_khz(cpuClkKhz, true);
  uart_init(uart0, 115200);
  // Set the GPIO pin mux to the UART - 0 is TX, 1 is RX
  gpio_set_function(0, GPIO_FUNC_UART);
  gpio_set_function(1, GPIO_FUNC_UART);
  uart_set_fifo_enabled(uart0,0) ;
  sleep_ms(1000) ;  
  uart_puts2( "\nHello R2RdacSigGenSweeped1V01 !\n");
  sprintf(stxt,"cpuKlkKhz=%10d kHz\n",cpuClkKhz) ; uart_puts2( stxt);
  FIFOinit() ;
  gpio_init_mask(dacMask) ;
  gpio_set_dir_out_masked(dacMask) ; 
  PWMsetup() ;
  for(int k=0 ; k<4096 ; k++){
    DDStable[k]=((int)(128+120*sin(twopi*k/4096.0)))<<2 ;
    }
  Tone1ddsPhase=0 ;
  Tone1ddsFrequency=Tone1FRQ/sampleFrequency*(double)(0x100000000L) ;
  multicore_launch_core1(generate) ;
  serCtrl() ;
  }
